/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */

/*  This file is the interface to system specific files */

#ifdef AIX
#define _ALL_SOURCE
#define POSIX
#endif

#ifdef POSIX
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE
#endif
#endif

#include <stdio.h>
#include <string.h>
#include "buffer.h"
#include "sysdep.h"
#include "misc.h"

int Screen_Height = 0;
int Screen_Width = 0;

extern char *get_cwd(void);

#ifdef msdos
#include "ibmpc.c"
#endif

#ifdef VMS
#include "vms.c"
#endif

#ifdef unix
#include "unix.c"
#endif

int INPUT_BUFFER_LEN = 0;
unsigned char INPUT_BUFFER[255];

/* if input char arrives with hi bit set, it is replaced by 2 characters:
   Meta_Char + char with hi bit off */
      
int Meta_Char = 27;

int getkey()
{
   int i, imax;
   unsigned char ch;
   if (!INPUT_BUFFER_LEN)
     {
	ch = (unsigned char) sys_getkey();
	if (ch & 0x80)
	  {
	     ch &= 0x7F;
	     ungetkey((int *) &ch);
	     ch = Meta_Char;		       /* escape char */
	  }
	return((int) ch);
     }

   ch = INPUT_BUFFER[0];
   if (ch & 0x80)
     {
	INPUT_BUFFER[0] = ch & 0x7F;
	return (Meta_Char);
     }

   INPUT_BUFFER_LEN--;
   imax = INPUT_BUFFER_LEN;
   for (i = 0; i < imax; i++)
     {
	INPUT_BUFFER[i] = INPUT_BUFFER[i + 1];
	imax = INPUT_BUFFER_LEN;
     }
   return((int) ch);
}

void ungetkey(int *ch)
{
   int i;
   for (i = 0; i < INPUT_BUFFER_LEN; i++)
     {
	INPUT_BUFFER[i+1] = INPUT_BUFFER[i];
     }
   INPUT_BUFFER[0] = (unsigned char) *ch;
   INPUT_BUFFER_LEN++;
}

void flush_input()
{
   int quit = KeyBoard_Quit;
   INPUT_BUFFER_LEN = 0;
   KeyBoard_Quit = 0;
#ifdef msdos
   while (input_pending(2,0)) if (!getkey()) getkey();
#else
   while (input_pending(2,0)) getkey();
#endif
   KeyBoard_Quit = quit;
}

#include <time.h>

unsigned long sys_time(void)
{
   return((unsigned long) time((time_t *) 0));
}

char *get_time()
{
    time_t clock;
    char *the_time;

    clock = time((time_t *) 0);
    the_time = ctime(&clock);
    /* returns the form Sun Sep 16 01:03:52 1985\n\0 */
    the_time[24] = '\0';
    return(the_time);
}

#ifdef unix

/* use berkeley interface
#include <sys/dir.h>
*/

static char Unix_Dir[255];
static char Unix_File[255];
static int File_Len;

#include <dirent.h>
static DIR *Dirp;

int sys_findnext(char *file)
{
   int mode;
#ifdef NEED_D_NAMLEN
#define dirent direct
#endif

   struct dirent *dp;

   while (1)
     {
	if (NULL == (dp = readdir(Dirp))) return(0);
#ifdef NEED_D_NAMLEN
	dp->d_name[dp->d_namlen] = 0;
#endif
	if (!strncmp(Unix_File, dp->d_name, File_Len)) break;
     }
   strcpy(file, Unix_Dir); strcat(file, dp->d_name);
   if (2 == sys_chmod(file, 0, &mode)) strcat(file, "/");
   return(1);
}

int sys_findfirst(char *the_file)
{
   char *f, *file;

   file = expand_filename(the_file);
   f = extract_file(file);

   strcpy (Unix_Dir, file);
   strcpy (Unix_File, f);
   File_Len = strlen(f);

   Unix_Dir[(int) (f - file)] = 0;

   if (Dirp != NULL) closedir(Dirp);

   if (NULL == (Dirp = (DIR *) opendir(Unix_Dir))) return(0);
   strcpy(the_file, file);
   return sys_findnext(the_file);
}

#endif

/* given a canonical filename, return pointer to its name */
char *extract_file(char *file)
{
   char *f;
#ifdef VMS
   char slash = ']';
#endif
#ifdef unix
   char slash = '/';
#endif
#ifdef msdos
   char slash = '\\';
#endif

   f = file + strlen(file);
   while (f >= file) if (*f == slash) return(++f); else f--;
   return(file);
}
